/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import lotr.client.gui.LOTRGuiButtonFsInvites;
import lotr.client.gui.LOTRGuiButtonFsOption;
import lotr.client.gui.LOTRGuiMenuBase;
import lotr.client.gui.LOTRGuiScrollPane;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRTitle;
import lotr.common.fellowship.LOTRFellowshipClient;
import lotr.common.network.LOTRPacketFellowshipCreate;
import lotr.common.network.LOTRPacketFellowshipDisband;
import lotr.common.network.LOTRPacketFellowshipDoPlayer;
import lotr.common.network.LOTRPacketFellowshipLeave;
import lotr.common.network.LOTRPacketFellowshipRename;
import lotr.common.network.LOTRPacketFellowshipRespondInvite;
import lotr.common.network.LOTRPacketFellowshipSetIcon;
import lotr.common.network.LOTRPacketFellowshipToggle;
import lotr.common.network.LOTRPacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LOTRGuiFellowships
extends LOTRGuiMenuBase {
    public static final ResourceLocation iconsTextures = new ResourceLocation("lotr:gui/fellowships.png");
    private Page page = Page.LIST;
    private List<LOTRFellowshipClient> allFellowshipsLeading = new ArrayList<LOTRFellowshipClient>();
    private List<LOTRFellowshipClient> allFellowshipsOther = new ArrayList<LOTRFellowshipClient>();
    private List<LOTRFellowshipClient> allFellowshipInvites = new ArrayList<LOTRFellowshipClient>();
    private LOTRFellowshipClient mouseOverFellowship;
    private LOTRFellowshipClient viewingFellowship;
    private String mouseOverPlayer;
    private boolean mouseOverPlayerRemove;
    private boolean mouseOverPlayerOp;
    private boolean mouseOverPlayerDeop;
    private boolean mouseOverPlayerTransfer;
    private String removingPlayer;
    private String oppingPlayer;
    private String deoppingPlayer;
    private String transferringPlayer;
    private boolean mouseOverInviteAccept;
    private boolean mouseOverInviteReject;
    private GuiButton buttonCreate;
    private GuiButton buttonCreateThis;
    private LOTRGuiButtonFsOption buttonInvitePlayer;
    private GuiButton buttonInviteThis;
    private LOTRGuiButtonFsOption buttonDisband;
    private GuiButton buttonDisbandThis;
    private GuiButton buttonLeave;
    private GuiButton buttonLeaveThis;
    private LOTRGuiButtonFsOption buttonSetIcon;
    private GuiButton buttonRemove;
    private GuiButton buttonTransfer;
    private LOTRGuiButtonFsOption buttonRename;
    private GuiButton buttonRenameThis;
    private GuiButton buttonBack;
    private GuiButton buttonInvites;
    private LOTRGuiButtonFsOption buttonPVP;
    private LOTRGuiButtonFsOption buttonHiredFF;
    private LOTRGuiButtonFsOption buttonMapShow;
    private GuiButton buttonOp;
    private GuiButton buttonDeop;
    private List<LOTRGuiButtonFsOption> orderedFsOptionButtons = new ArrayList<LOTRGuiButtonFsOption>();
    private GuiTextField textFieldName;
    private GuiTextField textFieldPlayer;
    private GuiTextField textFieldRename;
    public static final int entrySplit = 5;
    public static final int entryBorder = 10;
    public static final int selectBorder = 2;
    private int scrollWidgetWidth;
    private int scrollWidgetHeight;
    private int scrollBarX;
    private LOTRGuiScrollPane scrollPaneLeading;
    private LOTRGuiScrollPane scrollPaneOther;
    private LOTRGuiScrollPane scrollPaneMembers;
    private LOTRGuiScrollPane scrollPaneInvites;
    private int displayedFellowshipsLeading;
    private int displayedFellowshipsOther;
    private int displayedMembers;
    private int displayedInvites;

    public LOTRGuiFellowships() {
        this.xSize = 256;
        this.scrollWidgetWidth = 9;
        this.scrollWidgetHeight = 8;
        this.scrollBarX = this.xSize + 2 + 1;
        this.scrollPaneLeading = new LOTRGuiScrollPane(this.scrollWidgetWidth, this.scrollWidgetHeight);
        this.scrollPaneOther = new LOTRGuiScrollPane(this.scrollWidgetWidth, this.scrollWidgetHeight);
        this.scrollPaneMembers = new LOTRGuiScrollPane(this.scrollWidgetWidth, this.scrollWidgetHeight);
        this.scrollPaneInvites = new LOTRGuiScrollPane(this.scrollWidgetWidth, this.scrollWidgetHeight);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.field_146297_k.field_71439_g != null) {
            this.refreshFellowshipList();
        }
        int midX = this.guiLeft + this.xSize / 2;
        this.buttonCreate = new GuiButton(0, midX - 100, this.guiTop + 230, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.create"));
        this.field_146292_n.add(this.buttonCreate);
        this.buttonCreateThis = new GuiButton(1, midX - 100, this.guiTop + 170, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.createThis"));
        this.field_146292_n.add(this.buttonCreateThis);
        this.buttonInvitePlayer = new LOTRGuiButtonFsOption(2, midX, this.guiTop + 232, 0, 48, StatCollector.func_74838_a((String)"lotr.gui.fellowships.invite"));
        this.field_146292_n.add(this.buttonInvitePlayer);
        this.buttonInviteThis = new GuiButton(3, midX - 100, this.guiTop + 170, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.inviteThis"));
        this.field_146292_n.add(this.buttonInviteThis);
        this.buttonDisband = new LOTRGuiButtonFsOption(4, midX, this.guiTop + 232, 16, 48, StatCollector.func_74838_a((String)"lotr.gui.fellowships.disband"));
        this.field_146292_n.add(this.buttonDisband);
        this.buttonDisbandThis = new GuiButton(5, midX - 100, this.guiTop + 170, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.disbandThis"));
        this.field_146292_n.add(this.buttonDisbandThis);
        this.buttonLeave = new GuiButton(6, midX - 60, this.guiTop + 230, 120, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.leave"));
        this.field_146292_n.add(this.buttonLeave);
        this.buttonLeaveThis = new GuiButton(7, midX - 100, this.guiTop + 170, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.leaveThis"));
        this.field_146292_n.add(this.buttonLeaveThis);
        this.buttonSetIcon = new LOTRGuiButtonFsOption(8, midX, this.guiTop + 232, 48, 48, StatCollector.func_74838_a((String)"lotr.gui.fellowships.setIcon"));
        this.field_146292_n.add(this.buttonSetIcon);
        this.buttonRemove = new GuiButton(9, midX - 100, this.guiTop + 170, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.remove"));
        this.field_146292_n.add(this.buttonRemove);
        this.buttonTransfer = new GuiButton(10, midX - 100, this.guiTop + 170, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.transfer"));
        this.field_146292_n.add(this.buttonTransfer);
        this.buttonRename = new LOTRGuiButtonFsOption(11, midX, this.guiTop + 232, 32, 48, StatCollector.func_74838_a((String)"lotr.gui.fellowships.rename"));
        this.field_146292_n.add(this.buttonRename);
        this.buttonRenameThis = new GuiButton(12, midX - 100, this.guiTop + 170, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.renameThis"));
        this.field_146292_n.add(this.buttonRenameThis);
        this.buttonBack = new GuiButton(13, this.guiLeft - 10, this.guiTop, 20, 20, "<");
        this.field_146292_n.add(this.buttonBack);
        this.buttonInvites = new LOTRGuiButtonFsInvites(14, this.guiLeft + this.xSize - 16, this.guiTop, "");
        this.field_146292_n.add(this.buttonInvites);
        this.buttonPVP = new LOTRGuiButtonFsOption(15, midX, this.guiTop + 232, 64, 48, StatCollector.func_74838_a((String)"lotr.gui.fellowships.togglePVP"));
        this.field_146292_n.add(this.buttonPVP);
        this.buttonHiredFF = new LOTRGuiButtonFsOption(16, midX, this.guiTop + 232, 80, 48, StatCollector.func_74838_a((String)"lotr.gui.fellowships.toggleHiredFF"));
        this.field_146292_n.add(this.buttonHiredFF);
        this.buttonMapShow = new LOTRGuiButtonFsOption(17, midX, this.guiTop + 232, 96, 48, StatCollector.func_74838_a((String)"lotr.gui.fellowships.toggleMapShow"));
        this.field_146292_n.add(this.buttonMapShow);
        this.buttonOp = new GuiButton(18, midX - 100, this.guiTop + 170, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.op"));
        this.field_146292_n.add(this.buttonOp);
        this.buttonDeop = new GuiButton(19, midX - 100, this.guiTop + 170, 200, 20, StatCollector.func_74838_a((String)"lotr.gui.fellowships.deop"));
        this.field_146292_n.add(this.buttonDeop);
        this.orderedFsOptionButtons.clear();
        this.orderedFsOptionButtons.add(this.buttonInvitePlayer);
        this.orderedFsOptionButtons.add(this.buttonDisband);
        this.orderedFsOptionButtons.add(this.buttonRename);
        this.orderedFsOptionButtons.add(this.buttonSetIcon);
        this.orderedFsOptionButtons.add(this.buttonMapShow);
        this.orderedFsOptionButtons.add(this.buttonPVP);
        this.orderedFsOptionButtons.add(this.buttonHiredFF);
        this.textFieldName = new GuiTextField(this.field_146289_q, midX - 80, this.guiTop + 40, 160, 20);
        this.textFieldName.func_146203_f(40);
        this.textFieldPlayer = new GuiTextField(this.field_146289_q, midX - 80, this.guiTop + 40, 160, 20);
        this.textFieldRename = new GuiTextField(this.field_146289_q, midX - 80, this.guiTop + 40, 160, 20);
        this.textFieldRename.func_146203_f(40);
    }

    private void refreshFellowshipList() {
        this.allFellowshipsLeading.clear();
        this.allFellowshipsOther.clear();
        ArrayList<LOTRFellowshipClient> fellowships = new ArrayList<LOTRFellowshipClient>(LOTRLevelData.getData((EntityPlayer)this.field_146297_k.field_71439_g).getClientFellowships());
        for (LOTRFellowshipClient fs : fellowships) {
            if (fs.isOwned()) {
                this.allFellowshipsLeading.add(fs);
                continue;
            }
            this.allFellowshipsOther.add(fs);
        }
        this.allFellowshipInvites.clear();
        this.allFellowshipInvites.addAll(LOTRLevelData.getData((EntityPlayer)this.field_146297_k.field_71439_g).getClientFellowshipInvites());
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.refreshFellowshipList();
        this.textFieldName.func_146178_a();
        if (this.page != Page.CREATE) {
            this.textFieldName.func_146180_a("");
        }
        this.textFieldPlayer.func_146178_a();
        if (this.page != Page.INVITE) {
            this.textFieldPlayer.func_146180_a("");
        }
        this.textFieldRename.func_146178_a();
        if (this.page != Page.RENAME) {
            this.textFieldRename.func_146180_a("");
        }
    }

    private void alignOptionButtons() {
        ArrayList<GuiButton> activeOptionButtons = new ArrayList<GuiButton>();
        for (GuiButton guiButton : this.orderedFsOptionButtons) {
            if (!guiButton.field_146125_m) continue;
            activeOptionButtons.add(guiButton);
        }
        if (this.buttonLeave.field_146125_m) {
            activeOptionButtons.add(this.buttonLeave);
        }
        int midX = this.guiLeft + this.xSize / 2;
        int n = activeOptionButtons.size();
        if (n > 0) {
            int gap = 8;
            int allWidth = 0;
            for (GuiButton button : activeOptionButtons) {
                if (allWidth > 0) {
                    allWidth += gap;
                }
                allWidth += button.field_146120_f;
            }
            int x = midX - allWidth / 2;
            Iterator iterator = activeOptionButtons.iterator();
            while (iterator.hasNext()) {
                GuiButton activeOptionButton;
                GuiButton button = activeOptionButton = (GuiButton)iterator.next();
                button.field_146128_h = x;
                x += button.field_146120_f;
                x += gap;
            }
        }
    }

    public void func_73863_a(int i, int j, float f) {
        LOTRPlayerData playerData = LOTRLevelData.getData((EntityPlayer)this.field_146297_k.field_71439_g);
        boolean viewingOwned = this.viewingFellowship != null && this.viewingFellowship.isOwned();
        boolean viewingAdminned = this.viewingFellowship != null && this.viewingFellowship.isAdminned();
        this.mouseOverFellowship = null;
        this.mouseOverPlayer = null;
        this.mouseOverPlayerRemove = false;
        this.mouseOverPlayerOp = false;
        this.mouseOverPlayerDeop = false;
        this.mouseOverPlayerTransfer = false;
        if (this.page != Page.REMOVE) {
            this.removingPlayer = null;
        }
        if (this.page != Page.OP) {
            this.oppingPlayer = null;
        }
        if (this.page != Page.DEOP) {
            this.deoppingPlayer = null;
        }
        if (this.page != Page.TRANSFER) {
            this.transferringPlayer = null;
        }
        this.mouseOverInviteAccept = false;
        this.mouseOverInviteReject = false;
        boolean canCreateNew = playerData.canCreateFellowships(true);
        this.buttonCreate.field_146125_m = this.page == Page.LIST;
        this.buttonCreate.field_146124_l = this.buttonCreate.field_146125_m && canCreateNew;
        this.buttonCreateThis.field_146125_m = this.page == Page.CREATE;
        String checkValidName = this.checkValidFellowshipName(this.textFieldName.func_146179_b());
        this.buttonCreateThis.field_146124_l = this.buttonCreateThis.field_146125_m && checkValidName == null;
        this.buttonInvitePlayer.field_146125_m = this.buttonInvitePlayer.field_146124_l = this.page == Page.FELLOWSHIP && (viewingOwned || viewingAdminned);
        this.buttonInviteThis.field_146125_m = this.page == Page.INVITE;
        String checkValidPlayer = this.checkValidPlayerName(this.textFieldPlayer.func_146179_b());
        this.buttonInviteThis.field_146124_l = this.buttonInviteThis.field_146125_m && checkValidPlayer == null;
        this.buttonDisband.field_146125_m = this.buttonDisband.field_146124_l = this.page == Page.FELLOWSHIP && viewingOwned;
        this.buttonDisbandThis.field_146125_m = this.buttonDisbandThis.field_146124_l = this.page == Page.DISBAND;
        this.buttonLeave.field_146125_m = this.buttonLeave.field_146124_l = this.page == Page.FELLOWSHIP && !viewingOwned;
        this.buttonLeaveThis.field_146125_m = this.buttonLeaveThis.field_146124_l = this.page == Page.LEAVE;
        this.buttonSetIcon.field_146125_m = this.buttonSetIcon.field_146124_l = this.page == Page.FELLOWSHIP && (viewingOwned || viewingAdminned);
        this.buttonRemove.field_146125_m = this.buttonRemove.field_146124_l = this.page == Page.REMOVE;
        this.buttonTransfer.field_146125_m = this.buttonTransfer.field_146124_l = this.page == Page.TRANSFER;
        this.buttonRename.field_146125_m = this.buttonRename.field_146124_l = this.page == Page.FELLOWSHIP && viewingOwned;
        this.buttonRenameThis.field_146125_m = this.page == Page.RENAME;
        String checkValidRename = this.checkValidFellowshipName(this.textFieldRename.func_146179_b());
        this.buttonRenameThis.field_146124_l = this.buttonRenameThis.field_146125_m && checkValidRename == null;
        this.buttonBack.field_146125_m = this.buttonBack.field_146124_l = this.page != Page.LIST;
        this.buttonInvites.field_146125_m = this.buttonInvites.field_146124_l = this.page == Page.LIST;
        this.buttonPVP.field_146125_m = this.buttonPVP.field_146124_l = this.page == Page.FELLOWSHIP && (viewingOwned || viewingAdminned);
        if (this.buttonPVP.field_146124_l) {
            this.buttonPVP.setIconUV(64, this.viewingFellowship.getPreventPVP() ? 80 : 48);
        }
        this.buttonHiredFF.field_146125_m = this.buttonHiredFF.field_146124_l = this.page == Page.FELLOWSHIP && (viewingOwned || viewingAdminned);
        if (this.buttonHiredFF.field_146124_l) {
            this.buttonHiredFF.setIconUV(80, this.viewingFellowship.getPreventHiredFriendlyFire() ? 80 : 48);
        }
        this.buttonMapShow.field_146125_m = this.buttonMapShow.field_146124_l = this.page == Page.FELLOWSHIP && viewingOwned;
        if (this.buttonMapShow.field_146124_l) {
            this.buttonMapShow.setIconUV(96, this.viewingFellowship.getShowMapLocations() ? 48 : 80);
        }
        this.buttonOp.field_146125_m = this.buttonOp.field_146124_l = this.page == Page.OP;
        this.buttonDeop.field_146125_m = this.buttonDeop.field_146124_l = this.page == Page.DEOP;
        this.alignOptionButtons();
        this.setupScrollBars(i, j);
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(i, j, f);
        String s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.title");
        this.drawCenteredString(s, this.guiLeft + this.xSize / 2, this.guiTop - 30, 0xFFFFFF);
        if (this.page == Page.LIST) {
            int x = this.guiLeft;
            int y = this.scrollPaneLeading.paneY0;
            s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.leading");
            this.drawCenteredString(s, this.guiLeft + this.xSize / 2, y, 0xFFFFFF);
            y += this.field_146289_q.field_78288_b + 10;
            List<LOTRFellowshipClient> sortedLeading = this.sortFellowshipsForDisplay(this.allFellowshipsLeading);
            int[] leadingMinMax = this.scrollPaneLeading.getMinMaxIndices(sortedLeading, this.displayedFellowshipsLeading);
            for (int index = leadingMinMax[0]; index <= leadingMinMax[1]; ++index) {
                LOTRFellowshipClient fs = sortedLeading.get(index);
                this.drawFellowshipEntry(fs, x, y, i, j, false);
                y += this.field_146289_q.field_78288_b + 5;
            }
            y = this.scrollPaneOther.paneY0;
            s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.member");
            this.drawCenteredString(s, this.guiLeft + this.xSize / 2, y, 0xFFFFFF);
            y += this.field_146289_q.field_78288_b + 10;
            List<LOTRFellowshipClient> sortedOther = this.sortFellowshipsForDisplay(this.allFellowshipsOther);
            int[] otherMinMax = this.scrollPaneOther.getMinMaxIndices(sortedOther, this.displayedFellowshipsOther);
            for (int index = otherMinMax[0]; index <= otherMinMax[1]; ++index) {
                LOTRFellowshipClient fs = sortedOther.get(index);
                this.drawFellowshipEntry(fs, x, y, i, j, false);
                y += this.field_146289_q.field_78288_b + 5;
            }
            String invites = String.valueOf(playerData.getClientFellowshipInvites().size());
            int invitesX = this.buttonInvites.field_146128_h - 2 - this.field_146289_q.func_78256_a(invites);
            int invitesY = this.buttonInvites.field_146129_i + this.buttonInvites.field_146121_g / 2 - this.field_146289_q.field_78288_b / 2;
            this.field_146289_q.func_78276_b(invites, invitesX, invitesY, 0xFFFFFF);
            if (this.buttonInvites.func_146115_a()) {
                this.renderIconTooltip(i, j, StatCollector.func_74838_a((String)"lotr.gui.fellowships.invitesTooltip"));
            }
            if (!canCreateNew && this.buttonCreate.func_146115_a()) {
                s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.createLimit");
                this.drawCenteredString(s, this.guiLeft + this.xSize / 2, this.buttonCreate.field_146129_i + this.buttonCreate.field_146121_g + 4, 0xFFFFFF);
            }
            if (this.scrollPaneLeading.hasScrollBar) {
                this.scrollPaneLeading.drawScrollBar();
            }
            if (this.scrollPaneOther.hasScrollBar) {
                this.scrollPaneOther.drawScrollBar();
            }
        } else if (this.page == Page.CREATE) {
            s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.createName");
            this.drawCenteredString(s, this.guiLeft + this.xSize / 2, this.textFieldName.field_146210_g - 4 - this.field_146289_q.field_78288_b, 0xFFFFFF);
            this.textFieldName.func_146194_f();
            if (checkValidName != null) {
                this.drawCenteredString(checkValidName, this.guiLeft + this.xSize / 2, this.textFieldName.field_146210_g + this.textFieldName.field_146219_i + this.field_146289_q.field_78288_b, 0xFF0000);
            }
        } else if (this.page == Page.FELLOWSHIP) {
            int x = this.guiLeft;
            int y = this.guiTop + 10;
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.nameAndPlayers", (Object[])new Object[]{this.viewingFellowship.getName(), this.viewingFellowship.getMemberCount()});
            this.drawCenteredString(s, this.guiLeft + this.xSize / 2, y, 0xFFFFFF);
            y += this.field_146289_q.field_78288_b;
            y += 5;
            if (this.viewingFellowship.getIcon() != null) {
                this.drawFellowshipIcon(this.viewingFellowship, this.guiLeft + this.xSize / 2 - 8, y, 1.0f);
            }
            boolean preventPVP = this.viewingFellowship.getPreventPVP();
            boolean preventHiredFF = this.viewingFellowship.getPreventHiredFriendlyFire();
            boolean mapShow = this.viewingFellowship.getShowMapLocations();
            int iconPVPX = this.guiLeft + this.xSize - 36;
            int iconHFFX = this.guiLeft + this.xSize - 16;
            int iconMapX = this.guiLeft + this.xSize - 56;
            int iconY = y;
            int iconSize = 16;
            this.field_146297_k.func_110434_K().func_110577_a(iconsTextures);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(iconPVPX, iconY, 64, preventPVP ? 80 : 48, iconSize, iconSize);
            this.func_73729_b(iconHFFX, iconY, 80, preventHiredFF ? 80 : 48, iconSize, iconSize);
            this.func_73729_b(iconMapX, iconY, 96, mapShow ? 48 : 80, iconSize, iconSize);
            if (i >= iconPVPX && i < iconPVPX + iconSize && j >= iconY && j < iconY + iconSize) {
                this.renderIconTooltip(i, j, StatCollector.func_74838_a((String)(preventPVP ? "lotr.gui.fellowships.pvp.prevent" : "lotr.gui.fellowships.pvp.allow")));
            }
            if (i >= iconHFFX && i < iconHFFX + iconSize && j >= iconY && j < iconY + iconSize) {
                this.renderIconTooltip(i, j, StatCollector.func_74838_a((String)(preventHiredFF ? "lotr.gui.fellowships.hiredFF.prevent" : "lotr.gui.fellowships.hiredFF.allow")));
            }
            if (i >= iconMapX && i < iconMapX + iconSize && j >= iconY && j < iconY + iconSize) {
                this.renderIconTooltip(i, j, StatCollector.func_74838_a((String)(mapShow ? "lotr.gui.fellowships.mapShow.on" : "lotr.gui.fellowships.mapShow.off")));
            }
            y += iconSize;
            y += 10;
            int titleOffset = 0;
            for (String name : this.viewingFellowship.getAllPlayerNames()) {
                LOTRTitle.PlayerTitle title = this.viewingFellowship.getTitleFor(name);
                if (title == null) continue;
                String titleName = title.getFormattedTitle((EntityPlayer)this.field_146297_k.field_71439_g);
                int thisTitleWidth = this.field_146289_q.func_78256_a(titleName + " ");
                titleOffset = Math.max(titleOffset, thisTitleWidth);
            }
            this.drawPlayerEntry(this.viewingFellowship.getOwnerName(), x, y, titleOffset, i, j);
            y += this.field_146289_q.field_78288_b + 10;
            List<String> membersSorted = this.sortMemberNamesForDisplay(this.viewingFellowship);
            int[] membersMinMax = this.scrollPaneMembers.getMinMaxIndices(membersSorted, this.displayedMembers);
            for (int index = membersMinMax[0]; index <= membersMinMax[1]; ++index) {
                String name = membersSorted.get(index);
                this.drawPlayerEntry(name, x, y, titleOffset, i, j);
                y += this.field_146289_q.field_78288_b + 5;
            }
            for (Object bObj : this.field_146292_n) {
                GuiButton button = (GuiButton)bObj;
                if (!(button instanceof LOTRGuiButtonFsOption) || !button.field_146125_m || !button.func_146115_a()) continue;
                s = button.field_146126_j;
                this.drawCenteredString(s, this.guiLeft + this.xSize / 2, button.field_146129_i + button.field_146121_g + 4, 0xFFFFFF);
            }
            if (this.scrollPaneMembers.hasScrollBar) {
                this.scrollPaneMembers.drawScrollBar();
            }
        } else if (this.page == Page.INVITE) {
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.inviteName", (Object[])new Object[]{this.viewingFellowship.getName()});
            this.drawCenteredString(s, this.guiLeft + this.xSize / 2, this.textFieldPlayer.field_146210_g - 4 - this.field_146289_q.field_78288_b, 0xFFFFFF);
            this.textFieldPlayer.func_146194_f();
            if (checkValidPlayer != null) {
                this.drawCenteredString(checkValidPlayer, this.guiLeft + this.xSize / 2, this.textFieldPlayer.field_146210_g + this.textFieldPlayer.field_146219_i + this.field_146289_q.field_78288_b, 0xFF0000);
            }
        } else if (this.page == Page.DISBAND) {
            int x = this.guiLeft + this.xSize / 2;
            int y = this.guiTop + 30;
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.disbandCheck1", (Object[])new Object[]{this.viewingFellowship.getName()});
            this.drawCenteredString(s, x, y, 0xFFFFFF);
            s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.disbandCheck2");
            this.drawCenteredString(s, x, y += this.field_146289_q.field_78288_b, 0xFFFFFF);
            s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.disbandCheck3");
            this.drawCenteredString(s, x, y += this.field_146289_q.field_78288_b * 2, 0xFFFFFF);
            y += this.field_146289_q.field_78288_b;
        } else if (this.page == Page.LEAVE) {
            int x = this.guiLeft + this.xSize / 2;
            int y = this.guiTop + 30;
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.leaveCheck1", (Object[])new Object[]{this.viewingFellowship.getName()});
            this.drawCenteredString(s, x, y, 0xFFFFFF);
            s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.leaveCheck2");
            this.drawCenteredString(s, x, y += this.field_146289_q.field_78288_b, 0xFFFFFF);
            y += this.field_146289_q.field_78288_b * 2;
        } else if (this.page == Page.REMOVE) {
            int x = this.guiLeft + this.xSize / 2;
            int y = this.guiTop + 30;
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.removeCheck", (Object[])new Object[]{this.viewingFellowship.getName(), this.removingPlayer});
            List lines = this.field_146289_q.func_78271_c(s, this.xSize);
            for (String line : lines) {
                this.drawCenteredString(line, x, y, 0xFFFFFF);
                y += this.field_146289_q.field_78288_b;
            }
        } else if (this.page == Page.OP) {
            int x = this.guiLeft + this.xSize / 2;
            int y = this.guiTop + 30;
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.opCheck1", (Object[])new Object[]{this.viewingFellowship.getName(), this.oppingPlayer});
            List lines = this.field_146289_q.func_78271_c(s, this.xSize);
            for (String line : lines) {
                this.drawCenteredString(line, x, y, 0xFFFFFF);
                y += this.field_146289_q.field_78288_b;
            }
            y += this.field_146289_q.field_78288_b;
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.opCheck2", (Object[])new Object[]{this.viewingFellowship.getName(), this.oppingPlayer});
            lines = this.field_146289_q.func_78271_c(s, this.xSize);
            for (String line : lines) {
                this.drawCenteredString(line, x, y, 0xFFFFFF);
                y += this.field_146289_q.field_78288_b;
            }
        } else if (this.page == Page.DEOP) {
            int x = this.guiLeft + this.xSize / 2;
            int y = this.guiTop + 30;
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.deopCheck", (Object[])new Object[]{this.viewingFellowship.getName(), this.deoppingPlayer});
            List lines = this.field_146289_q.func_78271_c(s, this.xSize);
            for (String line : lines) {
                this.drawCenteredString(line, x, y, 0xFFFFFF);
                y += this.field_146289_q.field_78288_b;
            }
        } else if (this.page == Page.TRANSFER) {
            int x = this.guiLeft + this.xSize / 2;
            int y = this.guiTop + 30;
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.transferCheck1", (Object[])new Object[]{this.viewingFellowship.getName(), this.transferringPlayer});
            List lines = this.field_146289_q.func_78271_c(s, this.xSize);
            for (String line : lines) {
                this.drawCenteredString(line, x, y, 0xFFFFFF);
                y += this.field_146289_q.field_78288_b;
            }
            s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.transferCheck2");
            this.drawCenteredString(s, x, y += this.field_146289_q.field_78288_b, 0xFFFFFF);
            y += this.field_146289_q.field_78288_b;
        } else if (this.page == Page.RENAME) {
            s = StatCollector.func_74837_a((String)"lotr.gui.fellowships.renameName", (Object[])new Object[]{this.viewingFellowship.getName()});
            this.drawCenteredString(s, this.guiLeft + this.xSize / 2, this.textFieldRename.field_146210_g - 4 - this.field_146289_q.field_78288_b, 0xFFFFFF);
            this.textFieldRename.func_146194_f();
            if (checkValidRename != null) {
                this.drawCenteredString(checkValidRename, this.guiLeft + this.xSize / 2, this.textFieldRename.field_146210_g + this.textFieldRename.field_146219_i + this.field_146289_q.field_78288_b, 0xFF0000);
            }
        } else if (this.page == Page.INVITATIONS) {
            int x = this.guiLeft;
            int y = this.guiTop + 10;
            s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.invites");
            this.drawCenteredString(s, this.guiLeft + this.xSize / 2, y, 0xFFFFFF);
            y += this.field_146289_q.field_78288_b + 10;
            if (this.allFellowshipInvites.isEmpty()) {
                s = StatCollector.func_74838_a((String)"lotr.gui.fellowships.invitesNone");
                this.drawCenteredString(s, this.guiLeft + this.xSize / 2, y += this.field_146289_q.field_78288_b, 0xFFFFFF);
            } else {
                int[] invitesMinMax = this.scrollPaneInvites.getMinMaxIndices(this.allFellowshipInvites, this.displayedInvites);
                for (int index = invitesMinMax[0]; index <= invitesMinMax[1]; ++index) {
                    LOTRFellowshipClient fs = this.allFellowshipInvites.get(index);
                    this.drawFellowshipEntry(fs, x, y, i, j, true);
                    y += this.field_146289_q.field_78288_b + 5;
                }
            }
            if (this.scrollPaneInvites.hasScrollBar) {
                this.scrollPaneInvites.drawScrollBar();
            }
        }
    }

    private void drawFellowshipEntry(LOTRFellowshipClient fs, int x, int y, int mouseX, int mouseY, boolean isInvite) {
        this.drawFellowshipEntry(fs, x, y, mouseX, mouseY, isInvite, this.xSize);
    }

    public void drawFellowshipEntry(LOTRFellowshipClient fs, int x, int y, int mouseX, int mouseY, boolean isInvite, int selectWidth) {
        int selectX0 = x - 2;
        int selectX1 = x + selectWidth + 2;
        int selectY0 = y - 2;
        int selectY1 = y + this.field_146289_q.field_78288_b + 2;
        if (mouseX >= selectX0 && mouseX <= selectX1 && mouseY >= selectY0 && mouseY <= selectY1) {
            Gui.func_73734_a((int)selectX0, (int)selectY0, (int)selectX1, (int)selectY1, (int)0x55FFFFFF);
            this.mouseOverFellowship = fs;
        }
        boolean isMouseOver = this.mouseOverFellowship == fs;
        this.drawFellowshipIcon(fs, x, y, 0.5f);
        String fsName = fs.getName();
        int maxLength = 110;
        if (this.field_146289_q.func_78256_a(fsName) > maxLength) {
            String ellipsis = "...";
            while (this.field_146289_q.func_78256_a(fsName + ellipsis) > maxLength) {
                fsName = fsName.substring(0, fsName.length() - 1);
            }
            fsName = fsName + ellipsis;
        }
        String ownerName = fs.getOwnerName();
        boolean ownerOnline = LOTRGuiFellowships.isPlayerOnline(ownerName);
        this.field_146289_q.func_78276_b(fsName, x + 15, y, 0xFFFFFF);
        this.field_146289_q.func_78276_b(ownerName, x + 130, y, ownerOnline ? 0xFFFFFF : (isMouseOver ? 0xBBBBBB : 0x777777));
        if (isInvite) {
            int iconWidth = 8;
            int iconAcceptX = x + this.xSize - 18;
            int iconRejectX = x + this.xSize - 8;
            boolean accept = false;
            boolean reject = false;
            if (isMouseOver) {
                this.mouseOverInviteAccept = mouseX >= iconAcceptX && mouseX <= iconAcceptX + iconWidth && mouseY >= y && mouseY <= y + iconWidth;
                accept = this.mouseOverInviteAccept;
                this.mouseOverInviteReject = mouseX >= iconRejectX && mouseX <= iconRejectX + iconWidth && mouseY >= y && mouseY <= y + iconWidth;
                reject = this.mouseOverInviteReject;
            }
            this.field_146297_k.func_110434_K().func_110577_a(iconsTextures);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(iconAcceptX, y, 16, 16 + (accept ? 0 : iconWidth), iconWidth, iconWidth);
            this.func_73729_b(iconRejectX, y, 8, 16 + (reject ? 0 : iconWidth), iconWidth, iconWidth);
        } else {
            String memberCount = String.valueOf(fs.getMemberCount());
            String onlineMemberCount = String.valueOf(this.countOnlineMembers(fs)) + " | ";
            this.field_146289_q.func_78276_b(memberCount, x + this.xSize - this.field_146289_q.func_78256_a(memberCount), y, isMouseOver ? 0xBBBBBB : 0x777777);
            this.field_146289_q.func_78276_b(onlineMemberCount, x + this.xSize - this.field_146289_q.func_78256_a(memberCount) - this.field_146289_q.func_78256_a(onlineMemberCount), y, 0xFFFFFF);
        }
    }

    private void drawPlayerEntry(String player, int x, int y, int titleOffset, int mouseX, int mouseY) {
        int selectX0 = x - 2;
        int selectX1 = x + this.xSize + 2;
        int selectY0 = y - 2;
        int selectY1 = y + this.field_146289_q.field_78288_b + 2;
        if (mouseX >= selectX0 && mouseX <= selectX1 && mouseY >= selectY0 && mouseY <= selectY1) {
            Gui.func_73734_a((int)selectX0, (int)selectY0, (int)selectX1, (int)selectY1, (int)0x55FFFFFF);
            this.mouseOverPlayer = player;
        }
        boolean isMouseOver = this.mouseOverPlayer == player;
        String titleName = null;
        LOTRTitle.PlayerTitle title = this.viewingFellowship.getTitleFor(player);
        if (title != null) {
            titleName = title.getFormattedTitle((EntityPlayer)this.field_146297_k.field_71439_g);
        }
        if (titleName != null) {
            this.field_146289_q.func_78276_b(titleName, x, y, 0xFFFFFF);
        }
        this.field_146289_q.func_78276_b(player, x + titleOffset, y, LOTRGuiFellowships.isPlayerOnline(player) ? 0xFFFFFF : (isMouseOver ? 0xBBBBBB : 0x777777));
        boolean isOwner = this.viewingFellowship.getOwnerName().equals(player);
        boolean isAdmin = this.viewingFellowship.isAdmin(player);
        if (isOwner) {
            this.field_146297_k.func_110434_K().func_110577_a(iconsTextures);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(x + titleOffset + this.field_146289_q.func_78256_a(player + " "), y, 0, 0, 8, 8);
        } else if (isAdmin) {
            this.field_146297_k.func_110434_K().func_110577_a(iconsTextures);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(x + titleOffset + this.field_146289_q.func_78256_a(player + " "), y, 8, 0, 8, 8);
        }
        boolean owned = this.viewingFellowship.isOwned();
        boolean adminned = this.viewingFellowship.isAdminned();
        if (!isOwner && (owned || adminned)) {
            int iconWidth = 8;
            int iconRemoveX = x + this.xSize - 28;
            int iconOpDeopX = x + this.xSize - 18;
            int iconTransferX = x + this.xSize - 8;
            if (adminned) {
                iconRemoveX = x + this.xSize - 8;
            }
            boolean remove = false;
            boolean opDeop = false;
            boolean transfer = false;
            if (isMouseOver) {
                this.mouseOverPlayerRemove = mouseX >= iconRemoveX && mouseX <= iconRemoveX + iconWidth && mouseY >= y && mouseY <= y + iconWidth;
                remove = this.mouseOverPlayerRemove;
                if (owned) {
                    opDeop = isAdmin ? (this.mouseOverPlayerDeop = mouseX >= iconOpDeopX && mouseX <= iconOpDeopX + iconWidth && mouseY >= y && mouseY <= y + iconWidth) : (this.mouseOverPlayerOp = mouseX >= iconOpDeopX && mouseX <= iconOpDeopX + iconWidth && mouseY >= y && mouseY <= y + iconWidth);
                    this.mouseOverPlayerTransfer = mouseX >= iconTransferX && mouseX <= iconTransferX + iconWidth && mouseY >= y && mouseY <= y + iconWidth;
                    transfer = this.mouseOverPlayerTransfer;
                }
            }
            this.field_146297_k.func_110434_K().func_110577_a(iconsTextures);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(iconRemoveX, y, 8, 16 + (remove ? 0 : iconWidth), iconWidth, iconWidth);
            if (owned) {
                if (isAdmin) {
                    this.func_73729_b(iconOpDeopX, y, 32, 16 + (opDeop ? 0 : iconWidth), iconWidth, iconWidth);
                } else {
                    this.func_73729_b(iconOpDeopX, y, 24, 16 + (opDeop ? 0 : iconWidth), iconWidth, iconWidth);
                }
                this.func_73729_b(iconTransferX, y, 0, 16 + (transfer ? 0 : iconWidth), iconWidth, iconWidth);
            }
        }
    }

    private void drawFellowshipIcon(LOTRFellowshipClient fsClient, int x, int y, float scale) {
        ItemStack fsIcon = fsClient.getIcon();
        if (fsIcon != null) {
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3008);
            RenderHelper.func_74520_c();
            GL11.glDisable((int)2896);
            GL11.glEnable((int)32826);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            renderItem.func_82406_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), fsIcon, Math.round((float)x / scale), Math.round((float)y / scale));
            GL11.glPopMatrix();
            GL11.glDisable((int)2896);
        }
    }

    private void renderIconTooltip(int x, int y, String s) {
        float z = this.field_73735_i;
        int stringWidth = 200;
        List desc = this.field_146289_q.func_78271_c(s, stringWidth);
        this.func_146283_a(desc, x, y);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73735_i = z;
    }

    public static boolean isPlayerOnline(String player) {
        EntityClientPlayerMP mcPlayer = Minecraft.func_71410_x().field_71439_g;
        List list = mcPlayer.field_71174_a.field_147303_b;
        for (Object obj : list) {
            GuiPlayerInfo info = (GuiPlayerInfo)obj;
            if (!info.field_78831_a.equalsIgnoreCase(player)) continue;
            return true;
        }
        return false;
    }

    private int countOnlineMembers(LOTRFellowshipClient fs) {
        int i = 0;
        ArrayList<String> allPlayers = new ArrayList<String>(fs.getAllPlayerNames());
        for (String player : allPlayers) {
            if (!LOTRGuiFellowships.isPlayerOnline(player)) continue;
            ++i;
        }
        return i;
    }

    private List<LOTRFellowshipClient> sortFellowshipsForDisplay(List<LOTRFellowshipClient> list) {
        ArrayList<LOTRFellowshipClient> sorted = new ArrayList<LOTRFellowshipClient>(list);
        Collections.sort(sorted, new Comparator<LOTRFellowshipClient>(){

            @Override
            public int compare(LOTRFellowshipClient fs1, LOTRFellowshipClient fs2) {
                int count2;
                int count1 = fs1.getMemberCount();
                if (count1 == (count2 = fs2.getMemberCount())) {
                    return fs1.getName().toLowerCase().compareTo(fs2.getName().toLowerCase());
                }
                return -Integer.valueOf(count1).compareTo(count2);
            }
        });
        return sorted;
    }

    private List<String> sortMemberNamesForDisplay(final LOTRFellowshipClient fs) {
        ArrayList<String> members = new ArrayList<String>(fs.getMemberNames());
        Collections.sort(members, new Comparator<String>(){

            @Override
            public int compare(String player1, String player2) {
                boolean online2;
                boolean admin1 = fs.isAdmin(player1);
                boolean admin2 = fs.isAdmin(player2);
                boolean online1 = LOTRGuiFellowships.isPlayerOnline(player1);
                if (online1 == (online2 = LOTRGuiFellowships.isPlayerOnline(player2))) {
                    if (admin1 == admin2) {
                        return player1.toLowerCase().compareTo(player2.toLowerCase());
                    }
                    if (admin1 && !admin2) {
                        return -1;
                    }
                    if (!admin1 && admin2) {
                        return 1;
                    }
                } else {
                    if (online1 && !online2) {
                        return -1;
                    }
                    if (!online1 && online2) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        return members;
    }

    @Override
    protected void func_73869_a(char c, int i) {
        if (this.page == Page.CREATE && this.textFieldName.func_146201_a(c, i)) {
            return;
        }
        if (this.page == Page.INVITE && this.textFieldPlayer.func_146201_a(c, i)) {
            return;
        }
        if (this.page == Page.RENAME && this.textFieldRename.func_146201_a(c, i)) {
            return;
        }
        if (this.page != Page.LIST) {
            if (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
                this.page = this.page == Page.INVITE || this.page == Page.DISBAND || this.page == Page.LEAVE || this.page == Page.REMOVE || this.page == Page.OP || this.page == Page.DEOP || this.page == Page.TRANSFER || this.page == Page.RENAME ? Page.FELLOWSHIP : Page.LIST;
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        LOTRPacketFellowshipRespondInvite packet;
        super.func_73864_a(i, j, k);
        if (this.page == Page.LIST && this.mouseOverFellowship != null) {
            this.buttonSound();
            this.page = Page.FELLOWSHIP;
            this.viewingFellowship = this.mouseOverFellowship;
        }
        if (this.page == Page.CREATE) {
            this.textFieldName.func_146192_a(i, j, k);
        }
        if (this.page == Page.INVITE) {
            this.textFieldPlayer.func_146192_a(i, j, k);
        }
        if (this.page == Page.RENAME) {
            this.textFieldRename.func_146192_a(i, j, k);
        }
        if (this.page == Page.FELLOWSHIP && this.mouseOverPlayer != null && this.mouseOverPlayerRemove) {
            this.buttonSound();
            this.page = Page.REMOVE;
            this.removingPlayer = this.mouseOverPlayer;
        }
        if (this.page == Page.FELLOWSHIP && this.mouseOverPlayer != null && this.mouseOverPlayerOp) {
            this.buttonSound();
            this.page = Page.OP;
            this.oppingPlayer = this.mouseOverPlayer;
        }
        if (this.page == Page.FELLOWSHIP && this.mouseOverPlayer != null && this.mouseOverPlayerDeop) {
            this.buttonSound();
            this.page = Page.DEOP;
            this.deoppingPlayer = this.mouseOverPlayer;
        }
        if (this.page == Page.FELLOWSHIP && this.mouseOverPlayer != null && this.mouseOverPlayerTransfer) {
            this.buttonSound();
            this.page = Page.TRANSFER;
            this.transferringPlayer = this.mouseOverPlayer;
        }
        if (this.page == Page.INVITATIONS && this.mouseOverFellowship != null && this.mouseOverInviteAccept) {
            this.buttonSound();
            packet = new LOTRPacketFellowshipRespondInvite(this.mouseOverFellowship, true);
            LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
            this.mouseOverFellowship = null;
        }
        if (this.page == Page.INVITATIONS && this.mouseOverFellowship != null && this.mouseOverInviteReject) {
            this.buttonSound();
            packet = new LOTRPacketFellowshipRespondInvite(this.mouseOverFellowship, false);
            LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
            this.mouseOverFellowship = null;
        }
    }

    private void buttonSound() {
        this.buttonBack.func_146113_a(this.field_146297_k.func_147118_V());
    }

    private void setupScrollBars(int i, int j) {
        if (this.page == Page.LIST) {
            this.displayedFellowshipsLeading = this.allFellowshipsLeading.size();
            this.displayedFellowshipsOther = this.allFellowshipsOther.size();
            this.scrollPaneLeading.hasScrollBar = false;
            this.scrollPaneOther.hasScrollBar = false;
            while (this.displayedFellowshipsLeading + this.displayedFellowshipsOther > 12) {
                if (this.displayedFellowshipsOther >= this.displayedFellowshipsLeading) {
                    --this.displayedFellowshipsOther;
                    this.scrollPaneOther.hasScrollBar = true;
                    continue;
                }
                --this.displayedFellowshipsLeading;
                this.scrollPaneLeading.hasScrollBar = true;
            }
            this.scrollPaneLeading.paneX0 = this.guiLeft;
            this.scrollPaneLeading.scrollBarX0 = this.guiLeft + this.scrollBarX;
            this.scrollPaneLeading.paneY0 = this.guiTop + 10;
            this.scrollPaneLeading.paneY1 = this.scrollPaneLeading.paneY0 + this.field_146289_q.field_78288_b + 10 + (this.field_146289_q.field_78288_b + 5) * this.displayedFellowshipsLeading;
            this.scrollPaneLeading.mouseDragScroll(i, j);
            this.scrollPaneOther.paneX0 = this.guiLeft;
            this.scrollPaneOther.scrollBarX0 = this.guiLeft + this.scrollBarX;
            this.scrollPaneOther.paneY0 = this.scrollPaneLeading.paneY1 + 5;
            this.scrollPaneOther.paneY1 = this.scrollPaneOther.paneY0 + this.field_146289_q.field_78288_b + 10 + (this.field_146289_q.field_78288_b + 5) * this.displayedFellowshipsOther;
            this.scrollPaneOther.mouseDragScroll(i, j);
        }
        if (this.page == Page.FELLOWSHIP) {
            this.displayedMembers = this.viewingFellowship.getMemberNames().size();
            this.scrollPaneMembers.hasScrollBar = false;
            if (this.displayedMembers > 11) {
                this.displayedMembers = 11;
                this.scrollPaneMembers.hasScrollBar = true;
            }
            this.scrollPaneMembers.paneX0 = this.guiLeft;
            this.scrollPaneMembers.scrollBarX0 = this.guiLeft + this.scrollBarX;
            this.scrollPaneMembers.paneY0 = this.guiTop + 10 + this.field_146289_q.field_78288_b + 5 + 16 + 10 + this.field_146289_q.field_78288_b + 10;
            this.scrollPaneMembers.paneY1 = this.scrollPaneMembers.paneY0 + (this.field_146289_q.field_78288_b + 5) * this.displayedMembers;
            this.scrollPaneMembers.mouseDragScroll(i, j);
        } else {
            this.scrollPaneMembers.hasScrollBar = false;
            this.scrollPaneMembers.mouseDragScroll(i, j);
        }
        if (this.page == Page.INVITATIONS) {
            this.displayedInvites = this.allFellowshipInvites.size();
            this.scrollPaneInvites.hasScrollBar = false;
            if (this.displayedInvites > 15) {
                this.displayedInvites = 15;
                this.scrollPaneInvites.hasScrollBar = true;
            }
            this.scrollPaneInvites.paneX0 = this.guiLeft;
            this.scrollPaneInvites.scrollBarX0 = this.guiLeft + this.scrollBarX;
            this.scrollPaneInvites.paneY0 = this.guiTop + 10 + this.field_146289_q.field_78288_b + 10;
            this.scrollPaneInvites.paneY1 = this.scrollPaneInvites.paneY0 + (this.field_146289_q.field_78288_b + 5) * this.displayedInvites;
            this.scrollPaneInvites.mouseDragScroll(i, j);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int k = Mouse.getEventDWheel();
        if (k != 0) {
            int l;
            k = Integer.signum(k);
            if (this.page == Page.LIST) {
                if (this.scrollPaneLeading.hasScrollBar && this.scrollPaneLeading.mouseOver) {
                    l = this.allFellowshipsLeading.size() - this.displayedFellowshipsLeading;
                    this.scrollPaneLeading.mouseWheelScroll(k, l);
                }
                if (this.scrollPaneOther.hasScrollBar && this.scrollPaneOther.mouseOver) {
                    l = this.allFellowshipsOther.size() - this.displayedFellowshipsOther;
                    this.scrollPaneOther.mouseWheelScroll(k, l);
                }
            }
            if (this.page == Page.FELLOWSHIP && this.scrollPaneMembers.hasScrollBar && this.scrollPaneMembers.mouseOver) {
                l = this.viewingFellowship.getMemberNames().size() - this.displayedMembers;
                this.scrollPaneMembers.mouseWheelScroll(k, l);
            }
            if (this.page == Page.INVITATIONS && this.scrollPaneInvites.hasScrollBar && this.scrollPaneInvites.mouseOver) {
                l = this.allFellowshipInvites.size() - this.displayedInvites;
                this.scrollPaneInvites.mouseWheelScroll(k, l);
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button == this.buttonCreate) {
                this.page = Page.CREATE;
            } else if (button == this.buttonCreateThis) {
                String name = this.textFieldName.func_146179_b();
                if (this.checkValidFellowshipName(name) == null) {
                    name = StringUtils.trim((String)name);
                    LOTRPacketFellowshipCreate packet = new LOTRPacketFellowshipCreate(name);
                    LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
                }
                this.page = Page.LIST;
            } else if (button == this.buttonInvitePlayer) {
                this.page = Page.INVITE;
            } else if (button == this.buttonInviteThis) {
                String name = this.textFieldPlayer.func_146179_b();
                if (this.checkValidPlayerName(name) == null) {
                    name = StringUtils.trim((String)name);
                    LOTRPacketFellowshipDoPlayer packet = new LOTRPacketFellowshipDoPlayer(this.viewingFellowship, name, LOTRPacketFellowshipDoPlayer.PlayerFunction.INVITE);
                    LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
                }
                this.page = Page.FELLOWSHIP;
            } else if (button == this.buttonDisband) {
                this.page = Page.DISBAND;
            } else if (button == this.buttonDisbandThis) {
                LOTRPacketFellowshipDisband packet = new LOTRPacketFellowshipDisband(this.viewingFellowship);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
                this.page = Page.LIST;
            } else if (button == this.buttonLeave) {
                this.page = Page.LEAVE;
            } else if (button == this.buttonLeaveThis) {
                LOTRPacketFellowshipLeave packet = new LOTRPacketFellowshipLeave(this.viewingFellowship);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
                this.page = Page.LIST;
            } else if (button == this.buttonSetIcon) {
                LOTRPacketFellowshipSetIcon packet = new LOTRPacketFellowshipSetIcon(this.viewingFellowship);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
            } else if (button == this.buttonRemove) {
                LOTRPacketFellowshipDoPlayer packet = new LOTRPacketFellowshipDoPlayer(this.viewingFellowship, this.removingPlayer, LOTRPacketFellowshipDoPlayer.PlayerFunction.REMOVE);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
                this.page = Page.FELLOWSHIP;
            } else if (button == this.buttonOp) {
                LOTRPacketFellowshipDoPlayer packet = new LOTRPacketFellowshipDoPlayer(this.viewingFellowship, this.oppingPlayer, LOTRPacketFellowshipDoPlayer.PlayerFunction.OP);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
                this.page = Page.FELLOWSHIP;
            } else if (button == this.buttonDeop) {
                LOTRPacketFellowshipDoPlayer packet = new LOTRPacketFellowshipDoPlayer(this.viewingFellowship, this.deoppingPlayer, LOTRPacketFellowshipDoPlayer.PlayerFunction.DEOP);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
                this.page = Page.FELLOWSHIP;
            } else if (button == this.buttonTransfer) {
                LOTRPacketFellowshipDoPlayer packet = new LOTRPacketFellowshipDoPlayer(this.viewingFellowship, this.transferringPlayer, LOTRPacketFellowshipDoPlayer.PlayerFunction.TRANSFER);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
                this.page = Page.FELLOWSHIP;
            } else if (button == this.buttonRename) {
                this.page = Page.RENAME;
            } else if (button == this.buttonRenameThis) {
                String name = this.textFieldRename.func_146179_b();
                if (this.checkValidFellowshipName(name) == null) {
                    name = StringUtils.trim((String)name);
                    LOTRPacketFellowshipRename packet = new LOTRPacketFellowshipRename(this.viewingFellowship, name);
                    LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
                }
                this.page = Page.FELLOWSHIP;
            } else if (button == this.buttonBack) {
                this.func_73869_a('E', 1);
            } else if (button == this.buttonInvites) {
                this.page = Page.INVITATIONS;
            } else if (button == this.buttonPVP) {
                LOTRPacketFellowshipToggle packet = new LOTRPacketFellowshipToggle(this.viewingFellowship, LOTRPacketFellowshipToggle.ToggleFunction.PVP);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
            } else if (button == this.buttonHiredFF) {
                LOTRPacketFellowshipToggle packet = new LOTRPacketFellowshipToggle(this.viewingFellowship, LOTRPacketFellowshipToggle.ToggleFunction.HIRED_FF);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
            } else if (button == this.buttonMapShow) {
                LOTRPacketFellowshipToggle packet = new LOTRPacketFellowshipToggle(this.viewingFellowship, LOTRPacketFellowshipToggle.ToggleFunction.MAP_SHOW);
                LOTRPacketHandler.networkWrapper.sendToServer((IMessage)packet);
            } else {
                super.func_146284_a(button);
            }
        }
    }

    private String checkValidFellowshipName(String name) {
        if (!StringUtils.isWhitespace((CharSequence)name)) {
            if (LOTRLevelData.getData((EntityPlayer)this.field_146297_k.field_71439_g).anyMatchingFellowshipNames(name, true)) {
                return StatCollector.func_74838_a((String)"lotr.gui.fellowships.nameExists");
            }
            return null;
        }
        return "";
    }

    private String checkValidPlayerName(String name) {
        if (!StringUtils.isWhitespace((CharSequence)name)) {
            if (this.viewingFellowship.isPlayerIn(name)) {
                return StatCollector.func_74837_a((String)"lotr.gui.fellowships.playerExists", (Object[])new Object[]{name});
            }
            return null;
        }
        return "";
    }

    public LOTRFellowshipClient getMouseOverFellowship() {
        return this.mouseOverFellowship;
    }

    public void clearMouseOverFellowship() {
        this.mouseOverFellowship = null;
    }

    public static enum Page {
        LIST,
        CREATE,
        FELLOWSHIP,
        INVITE,
        DISBAND,
        LEAVE,
        REMOVE,
        OP,
        DEOP,
        TRANSFER,
        RENAME,
        INVITATIONS;

    }
}

